<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <base href="<?php echo e(route('admin')); ?>">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <meta name="description" content="Movies, TV Shows and Live TV">


    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">


    <!-- Title -->
    <title><?php echo e(config('app.name')); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/favicon.png')); ?>"/>


     <!-- CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/mdi/css/materialdesignicons.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/base/vendor.bundle.base.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom.css')); ?>">



</head>
<body>
<div class="container-scroller">

<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- partial -->
    <div class="main-panel">
        <div class="content-wrapper">


            <main id="app">
                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>
    </div>

</div>


<!-- Scripts -->
<script type="text/javascript">window.url = <?php echo json_encode(url('/')); ?>;</script>



<script src="<?php echo e(asset('js/manifest.js')); ?>"></script>   
<script src="<?php echo e(asset('js/vendor.js')); ?>"></script>   
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>    
    <script src="<?php echo e(asset('js/custom.js')); ?>"></script>
    <script src="https://cdn.onesignal.com/sdks/OneSignalSDK.js" async=""></script>




</body>
</html>
<?php /**PATH C:\xampp\htdocs\resources\views/layouts/admin.blade.php ENDPATH**/ ?>